/* $XFree86: xc/programs/Xserver/hw/xfree86/vga256/drivers/mxic/mxic_cursor.c,v 1.1.2.2 1997/05/31 13:34:45 dawes Exp $ */

/*
 *
 * Copyright 1991 MIPS Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of MIPS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  MIPS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * MIPS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL MIPS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Ported to MX8625x by Stephen H.L.Wang
 *
 * version 0.2.1 - 11/8/1998
 *	1. Enable H/W cursor now.
 *
 * version 0.2alpha - 12/29/1997
 */

/*
 * Hardware cursor support for S3 ViRGE SVGA driver. Taken with
 * very few changes from the accel/s3_virge cursor file.
 * S. Marineau, 19/04/97.
 */


#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "input.h"
#include "cursorstr.h"
#include "regionstr.h"
#include "scrnintstr.h"
#include "servermd.h"
#include "windowstr.h"

#include "compiler.h"
#include "vga256.h"
#include "xf86.h"
#include "mipointer.h"
#include "inputstr.h"
#include "xf86Priv.h"
#include "xf86_Option.h"
#include "xf86_OSlib.h"
#include "vga.h"
#include "xf86xaa.h"
#include "mxic_driver.h"

static Bool MXICRealizeCursor();
static Bool MXICUnrealizeCursor();
static void MXICSetCursor();
static void MXICMoveCursor();
static void MXICRecolorCursor();

static miPointerSpriteFuncRec mxicPointerSpriteFuncs =
{
   MXICRealizeCursor,
   MXICUnrealizeCursor,
   MXICSetCursor,
   MXICMoveCursor,
};

extern miPointerScreenFuncRec xf86PointerScreenFuncs;
extern xf86InfoRec xf86Info;

/* For byte swapping, use the XAA array */
extern unsigned char byte_reversed[256];
extern MXICPRIV mxicPriv;
extern pointer mxicMmioMem;

static int mxicCursGeneration = -1;
static int mxicHotX;
static int mxicHotY;
static int mxicCursorVRAMMemSegment;
static CursorPtr mxicCursorpCurs;

#define MAX_CURS 32

/*
 * This is a high-level init function, called once at
 * startup and once every time the server VC is reentered;
 * it passes a local miPointerSpriteFuncRec with
 * additional functions that we need to provide.
 * It is called by the SVGA server.
 */

Bool
MXICCursorInit(pm, pScr)
     char *pm;
     ScreenPtr pScr;
{
   void MXICHideCursor();

#ifdef DEBUGTRACE
   ErrorF("MXICCursorInit(pm=0x%x,pScr=0x%x)\n", pm, pScr);
#endif

   if (mxicCursGeneration != serverGeneration) {
      if (!(miPointerInitialize(pScr, &mxicPointerSpriteFuncs,
	   &xf86PointerScreenFuncs, FALSE)))
               return FALSE;

      mxicHotX = 0;
      mxicHotY = 0;
      pScr->RecolorCursor = MXICRecolorCursor;
      mxicCursGeneration = serverGeneration;
   }
   mxicCursorVRAMMemSegment = vga256InfoRec.videoRam - 1;
   MXICHideCursor();
   return TRUE;
}


/*
 * This enables displaying of the cursor by the MXIC graphics chip.
 * It's a local function, it's not called from outside of the module.
 */

void
MXICShowCursor()
{
   unsigned char tmp;

#ifdef DEBUGTRACE
   ErrorF("MXICShowCursor\n");
#endif

   /* turn cursor on */
   outb(vgaCRIndex, 0x66);
   tmp = inb(vgaCRReg);
   outb(vgaCRReg, tmp | 0x01);
}

/*
 * This disables displaying of the cursor by the TSENG graphics chip.
 * This is also a local function, it's not called from outside.
 */

void
MXICHideCursor()
{
   unsigned char tmp;

#ifdef DEBUGTRACE
   ErrorF("MXICHideCursor\n");
#endif

   /* turn cursor off */
   outb(vgaCRIndex, 0x66);
   tmp = inb(vgaCRReg);
   outb(vgaCRReg, tmp & 0xFE);
}

/*
 * This function is called when a new cursor image is requested by
 * the server. The main thing to do is convert the bitwise image
 * provided by the server into a format that the graphics card
 * can conveniently handle, and store that in system memory.
 */

#define SWAP_WORD(x)	(((unsigned short)(x)>>8)|((unsigned short)(x)<<8))

static Bool
MXICRealizeCursor(pScr, pCurs)
     ScreenPtr pScr;
     CursorPtr pCurs;

{
   register int i, j, k, k1;
   unsigned short *pServMsk;
   unsigned short *pServSrc;
   int   index = pScr->myNum;
   pointer *pPriv = &pCurs->bits->devPriv[index];
   int   wsrc, h;
   unsigned short *ram;
   CursorBitsPtr bits = pCurs->bits;

#ifdef DEBUGTRACE
   ErrorF("MXICRealizeCursor(pScr=0x%x,pCurs=0x%x)\n", pScr, pCurs);
#endif

   if (pCurs->bits->refcnt > 1)
      return TRUE;

   ram = (unsigned short *)xalloc(1024);
   *pPriv = (pointer) ram;

   if (!ram)
      return FALSE;

   pServSrc = (unsigned short *)bits->source;
   pServMsk = (unsigned short *)bits->mask;

   h = bits->height;
   if (h > MAX_CURS)
      h = MAX_CURS;

   wsrc = PixmapBytePad(bits->width, 1);	/* words per line */

#if 1
#if 0
   for (i = 0; i < MAX_CURS; i++) {
      for (j = 0; j < MAX_CURS / 16; j++) {
	 unsigned short mask, source;

	 if (i < h && j < wsrc / 2) {
	    mask = *pServMsk++;
	    source = *pServSrc++;

	    ((char *)&mask)[0] = byte_reversed[((unsigned char *)&mask)[0]];
	    ((char *)&mask)[1] = byte_reversed[((unsigned char *)&mask)[1]];

	    ((char *)&source)[0] = byte_reversed[((unsigned char *)&source)[0]];
	    ((char *)&source)[1] = byte_reversed[((unsigned char *)&source)[1]];

	    if (j < MAX_CURS / 8) { /* j < MAX_CURS / 16 implies this */
	       *ram++ = ~mask;
	       *ram++ = source & mask;
	    }
	 } else {
	    *ram++ = 0xffff;
	    *ram++ = 0x0;
	 }
      }
      if (j < wsrc / 2) {
	 pServMsk += (wsrc/2 - j);
	 pServSrc += (wsrc/2 - j);
      }
   }
#else
   for (i = 0; i < MAX_CURS; i++) {
      for (j = 0; j < MAX_CURS / 16; j++) {
	 unsigned short mask, source;
	 unsigned int tmpi;
	 unsigned char tm, ts;

	 if (i < h && j < wsrc / 2) {
	    mask = *pServMsk++;
	    source = *pServSrc++;

	    /*
	    ((char *)&mask)[0] = byte_reversed[((unsigned char *)&mask)[0]];
	    ((char *)&mask)[1] = byte_reversed[((unsigned char *)&mask)[1]];

	    ((char *)&source)[0] = byte_reversed[((unsigned char *)&source)[0]];
	    ((char *)&source)[1] = byte_reversed[((unsigned char *)&source)[1]];
	    */

	    tmpi = 0;
	    for (k1=0; k1<2; k1++)
	    {
	      tm = ~((char *)&mask)[1-k1];
	      ts = ((char *)&source)[1-k1];
	      for (k=0; k<8; k++)
	      {
		 tmpi <<= 1;
		 if (tm & 0x1)
			tmpi |= 1;
		 tmpi <<= 1;
		 if (ts & 0x1)
			tmpi |= 1;
		 tm >>= 1;
		 ts >>= 1;
	      }
	    }
	    *ram++ = (unsigned short)SWAP_WORD(tmpi);
	    *ram++ = (unsigned short)SWAP_WORD(tmpi>>16);
	 } else {
	    *ram++ = 0xaaaa;
	    *ram++ = 0xaaaa;
	 }
      }
      if (j < wsrc / 2) {
	 pServMsk += (wsrc/2 - j);
	 pServSrc += (wsrc/2 - j);
      }
   }
#endif
#else
/* test only */
   for (i = 0; i < MAX_CURS; i++) {
	    *ram++ = 0x4040;
	    *ram++ = 0x4040;
	    *ram++ = 0x4040;
	    *ram++ = 0x4040;
   }
#endif
   return TRUE;
}

/*
 * This is called when a cursor is no longer used. The intermediate
 * cursor image storage that we created needs to be deallocated.
 */

static Bool
MXICUnrealizeCursor(pScr, pCurs)
     ScreenPtr pScr;
     CursorPtr pCurs;
{
   pointer priv;

#ifdef DEBUGTRACE
   ErrorF("MXICUnrealizeCursor(pScr=0x%x,pCurs=0x%x)\n", pScr, pCurs);
#endif

   if (pCurs->bits->refcnt <= 1 &&
     (priv = pCurs->bits->devPriv[pScr->myNum])) {
         xfree(priv);
         pCurs->bits->devPriv[pScr->myNum] = 0x0;
   }

   return TRUE;
}

/*
 * This function should make the graphics chip display new cursor that
 * has already been "realized". We need to upload it to video memory,
 * make the graphics chip display it.
 * This is a local function that is not called from outside of this
 * module (although it largely corresponds to what the SetCursor
 * function in the Pointer record needs to do).
 */

static void
MXICLoadCursor(pScr, pCurs, x, y)
     ScreenPtr pScr;
     CursorPtr pCurs;
     int x, y;
{
   int   index = pScr->myNum;
   unsigned short *ram;
   unsigned char tmp;
   char * videobuffer = (char *) xf86AccelInfoRec.FramebufferBase;

   if (!xf86VTSema)
      return;

   if (!pCurs)
      return;
 
#ifdef DEBUGTRACE
   ErrorF("MXICLoadCursor(pScr=0x%x,pCurs=0x%x,x=%i,y=%i)\n", pScr, pCurs, x, y);
#endif

   /* Remember which cursor is loaded */
   mxicCursorpCurs = pCurs;

   /* Wait for vertical retrace */
   /* VerticalRetraceWait(); */

   /* turn cursor off */
   MXICHideCursor();

   ram = (unsigned short *)pCurs->bits->devPriv[index];
   /* MemToBus(videobuffer + mxicCursorVRAMMemSegment * 1024, (char *) ram, 1024); */
   MemToBus(videobuffer + mxicCursorVRAMMemSegment * 1024 + (1024-256), (char *) ram, 256);

   /* Wait for vertical retrace */
   VerticalRetraceWait();

   /* position cursor */
   MXICMoveCursor(0, x, y);
   MXICRecolorCursor(pScr, pCurs, TRUE);

   /* turn cursor on */
   MXICShowCursor();
}

/*
 * This function should display a new cursor at a new position.
 */

static void
MXICSetCursor(pScr, pCurs, x, y, generateEvent)
     ScreenPtr pScr;
     CursorPtr pCurs;
     int   x, y;
     Bool  generateEvent;

{
   int index = pScr->myNum;

   if (!pCurs)
      return;

#ifdef DEBUGTRACE
   ErrorF("MXICSetCursor(pScr=0x%x,pCurs=0x%x,x=%i,y=%i)\n", pScr, pCurs, x, y);
#endif

   mxicHotX = pCurs->bits->xhot;
   mxicHotY = pCurs->bits->yhot;
   MXICLoadCursor(pScr, pCurs, x, y);

}

/*
 * This function should redisplay a cursor that has been
 * displayed earlier. It is called by the SVGA server.
 */

void
MXICRestoreCursor(pScr)
     ScreenPtr pScr;
{
   int index = pScr->myNum;
   int x, y;

#ifdef DEBUGTRACE
   ErrorF("MXICRestoreCursor(pScr=0x%x)\n", pScr);
#endif

   miPointerPosition(&x, &y);
   MXICLoadCursor(pScr, mxicCursorpCurs, x, y);
}

void
MXICRepositionCursor(pScr)
     ScreenPtr pScr;
{
   int x, y;


   miPointerPosition(&x, &y);
   /* Wait for vertical retrace */
   VerticalRetraceWait();
   MXICMoveCursor(pScr, x, y);
}

/*
 * This function is called when the current cursor is moved. It makes
 * the graphic chip display the cursor at the new position.
 */

static void
MXICMoveCursor(pScr, x, y)
     ScreenPtr pScr;
     int   x, y;
{
   unsigned char xoff, yoff;

   if (!xf86VTSema)
      return;

   x -= vga256InfoRec.frameX0;
   y -= vga256InfoRec.frameY0;

   x -= mxicHotX;
   y -= mxicHotY;

   if (vgaBitsPerPixel > 16)
      x &= ~1;

   /*
    * Make these even when used.  There is a bug/feature on at least
    * some chipsets that causes a "shadow" of the cursor in interlaced
    * mode.  Making this even seems to have no visible effect, so just
    * do it for the generic case.
    */
   if (x < 0) {
     xoff = ((-x) & 0xFE);
     x = 0;
   } else {
     xoff = 0;
   }

   if (y < 0) {
      yoff = ((-y) & 0xFE);
      y = 0;
   } else {
      yoff = 0;
   }

   /* WaitIdle(); */

   /* This is the recomended order to move the cursor */
   outb(vgaCRIndex, 0x61);
   outb(vgaCRReg, (x & 0xff00)>>8);

   outb(vgaCRIndex, 0x60);
   outb(vgaCRReg, (x & 0xff));

   outb(vgaCRIndex, 0x63);
   outb(vgaCRReg, (y & 0xff));

   outb(vgaCRIndex, 0x62);
   outb(vgaCRReg, xoff);

   outb(vgaCRIndex, 0x65);
   outb(vgaCRReg, yoff);

   outb(vgaCRIndex, 0x64);
   outb(vgaCRReg, (y & 0xff00)>>8);
}


/*
 * This is a local function that programs the colors of the cursor
 * on the graphics chip.
 * Adapted from accel/s3/s3Cursor.c.
 */

static void
MXICRecolorCursor(pScr, pCurs, displayed)
     ScreenPtr pScr;
     CursorPtr pCurs;
     Bool displayed;
{
   ColormapPtr pmap;
   unsigned short packedcolfg, packedcolbg;
   xColorItem sourceColor, maskColor;

   if (!xf86VTSema)
      return;

   if (!displayed)
      return;

   switch (vgaBitsPerPixel) {
   case 8:
      vgaGetInstalledColormaps(pScr, &pmap);
      sourceColor.red = pCurs->foreRed;
      sourceColor.green = pCurs->foreGreen;
      sourceColor.blue = pCurs->foreBlue;
      FakeAllocColor(pmap, &sourceColor);
      maskColor.red = pCurs->backRed;
      maskColor.green = pCurs->backGreen;
      maskColor.blue = pCurs->backBlue;
      FakeAllocColor(pmap, &maskColor);
      FakeFreeColor(pmap, sourceColor.pixel);
      FakeFreeColor(pmap, maskColor.pixel);

      outb(vgaCRIndex, 0x6A);
      outb(vgaCRReg, sourceColor.pixel);
      outb(vgaCRIndex, 0x67);
      outb(vgaCRReg, maskColor.pixel);
      break;
   case 16:
      if (vga256InfoRec.weight.green == 5) {
	 packedcolfg = ((pCurs->foreRed   & 0xf800) >>  1)
	    | ((pCurs->foreGreen & 0xf800) >>  6)
	       | ((pCurs->foreBlue  & 0xf800) >> 11);
	 packedcolbg = ((pCurs->backRed   & 0xf800) >>  1)
	    | ((pCurs->backGreen & 0xf800) >>  6)
	       | ((pCurs->backBlue  & 0xf800) >> 11);
      } else {
	 packedcolfg = ((pCurs->foreRed   & 0xf800) >>  0)
	    | ((pCurs->foreGreen & 0xfc00) >>  5)
	       | ((pCurs->foreBlue  & 0xf800) >> 11);
	 packedcolbg = ((pCurs->backRed   & 0xf800) >>  0)
	    | ((pCurs->backGreen & 0xfc00) >>  5)
	       | ((pCurs->backBlue  & 0xf800) >> 11);
      }


      outb(vgaCRIndex, 0x6A);
      outb(vgaCRReg, packedcolfg>>8);
      outb(vgaCRIndex, 0x6B);
      outb(vgaCRReg, packedcolfg);
      outb(vgaCRIndex, 0x67);
      outb(vgaCRReg, packedcolbg>>8);
      outb(vgaCRIndex, 0x68);
      outb(vgaCRReg, packedcolbg);
      break;
   case 24:
   case 32:
      outb(vgaCRIndex, 0x6C);
      outb(vgaCRReg, pCurs->foreBlue >>8);
      outb(vgaCRIndex, 0x6B);
      outb(vgaCRReg, pCurs->foreGreen>>8);
      outb(vgaCRIndex, 0x6A);
      outb(vgaCRReg, pCurs->foreRed  >>8);

      outb(vgaCRIndex, 0x69);
      outb(vgaCRReg, pCurs->backBlue >>8);
      outb(vgaCRIndex, 0x68);
      outb(vgaCRReg, pCurs->backGreen>>8);
      outb(vgaCRIndex, 0x67);
      outb(vgaCRReg, pCurs->backRed  >>8);
      break;
   }
}

/*
 * This doesn't do very much. It just calls the mi routine. It is called
 * by the SVGA server.
 */

void
MXICWarpCursor(pScr, x, y)
     ScreenPtr pScr;
     int   x, y;
{
   miPointerWarpCursor(pScr, x, y);
   xf86Info.currentScreen = pScr;
}

/*
 * This function is called by the SVGA server. It returns the
 * size of the hardware cursor that we support when asked for.
 * It is called by the SVGA server.
 */

void
MXICQueryBestSize(class, pwidth, pheight, pScreen)
     int class;
     unsigned short *pwidth;
     unsigned short *pheight;
     ScreenPtr pScreen;
{
   if (*pwidth > 0) {
      switch (class) {
         case CursorShape:
	    /*
	    if (*pwidth > 32)
	       *pwidth = 32;
	    if (*pheight > 32)
	       *pheight = 32;
	    */
	    *pwidth = 32;
	    *pheight = 32;
	    break;
         default:
	    mfbQueryBestSize(class, pwidth, pheight, pScreen);
	    break;
      }
   }
}


